/*
 # Version: 1.0
 # Auteur: Etienne Vautherin pour Développer pour l'iPhone et l'iPad
 # http://alltouches.com
 # Les instructions de ce fichier sont fournies à titre d'illustration et n'engagent en rien leur auteur
 */

#import "DetailViewController_Pad.h"
#import "RootViewController_Pad.h"


@interface DetailViewController_Pad ()
@property (nonatomic, retain) UIPopoverController *popoverController;
@end



@implementation DetailViewController_Pad

@synthesize toolbar, popoverController;

#pragma mark -
#pragma mark Managing the detail item

/*
 When setting the detail item, update the view and dismiss the popover controller if it's showing.
 */
- (void)setDetailItem:(id)newDetailItem {
	[super setDetailItem:newDetailItem];

    if (popoverController != nil) {
        [popoverController dismissPopoverAnimated:YES];
    }        
}


#pragma mark -
#pragma mark Split view support

- (void)splitViewController: (UISplitViewController*)svc willHideViewController:(UIViewController *)aViewController withBarButtonItem:(UIBarButtonItem*)barButtonItem forPopoverController: (UIPopoverController*)pc {
    
    barButtonItem.title = NSLocalizedString(@"Navigation", @"Title for navigation button");
    NSMutableArray *items = [[toolbar items] mutableCopy];
    [items insertObject:barButtonItem atIndex:0];
    [toolbar setItems:items animated:YES];
    [items release];
    self.popoverController = pc;
}


// Called when the view is shown again in the split view, invalidating the button and popover controller.
- (void)splitViewController: (UISplitViewController*)svc willShowViewController:(UIViewController *)aViewController invalidatingBarButtonItem:(UIBarButtonItem *)barButtonItem {
    
    NSMutableArray *items = [[toolbar items] mutableCopy];
    [items removeObjectAtIndex:0];
    [toolbar setItems:items animated:YES];
    [items release];
    self.popoverController = nil;
}


#pragma mark -
#pragma mark View lifecycle

- (CGRect)detailViewFrame {
	CGSize frameSize = self.view.frame.size;
	CGFloat toolBarHeight = toolbar.frame.size.height;
	return CGRectMake(0.0, toolBarHeight, frameSize.width, frameSize.height - toolBarHeight);
}

- (void)viewDidUnload {
    self.popoverController = nil;
}


#pragma mark -
#pragma mark Memory management

- (void)dealloc {
    [popoverController release];
    [toolbar release];
    
    [super dealloc];
}

@end
